/*
   This program starts a child process and wants to redirect
   the child's stdin to a file and redirect the child's stdout
   to a file. But this cannot be done in Java 6 (or earlier).
   So we fake it (in a complicated way).

   In this program, two independent "threads" are created.
   One thread "pumps" data from the input file to the
   child's stdin. The other thread "pumps" data from the
   child's stdout to the output file. These two threads
   (which act as pumps between streams) are replacements for
   the "pipes" that should be connecting the streams, but
   which Java does not provide.


   Important: Notice that this program is logically the
   same as the following command line.

   C:\> java Double < L200.txt > result.txt

   In the case of the above command line, the shell
   program (cmd.exe) sets up the I/O redirection before
   running the program Double.class. In the case of this
   program, the program itself does the I/O redirection
   for its child.
*/
import java.util.Scanner;
import java.io.*;

public class Java6_RedirectChildStdinStdoutToFiles_ver3
{
   public static void main(String[] args) throws IOException, InterruptedException
   {
      // Create a command line for running the child.
      String cmd = "java Double";
      // Execute the filter.
      Process process = Runtime.getRuntime().exec(cmd);

      // Create a stream that writes data to the child's stdin stream.
      final PrintStream stdinOfChild =  new PrintStream( process.getOutputStream() );
      // Create a stream that reads data from the child's stdout stream.
      final Scanner stdoutOfChild = new Scanner( process.getInputStream() );

      // Create a stream that reads data from the input file.
      final Scanner inputFile = new Scanner( new FileInputStream( "L200.txt" ) );
      // Create a stream that writes data to the output file.
      final PrintStream outputFile =  new PrintStream( new FileOutputStream( "result.txt" ) );


      // Create a "pump" between the input file
      // and the child's input stream.
      new Thread(                      // Create a Thread object, holding
                  new Runnable()       // an anonymous instance of a Runnable object.
                  {  public void run() // Implement the Runable interface.
                     {  while(inputFile.hasNextLine())
                        {  String oneLine = inputFile.nextLine(); // read from input file
                           stdinOfChild.println( oneLine );       // write to child's stdin
                           //stdinOfChild.flush();
                        }
                        stdinOfChild.close(); //IMPORTANT (otherwise the child hangs)
                     }
                  }
               ).start(); //start the thread (call the run() method in the Runnable object)


      // Create a "pump" between the child's output stream
      // and the output file.
      new Thread(                     // Create a Thread object, holding
                 new Runnable()       // an anonymous instance of a Runnable object.
                 { public void run()  // Implement the Runable interface.
                   { while(stdoutOfChild.hasNextLine())
                     { String oneLine = stdoutOfChild.nextLine(); // read from child's stdout
                       outputFile.println( oneLine );             // write to output file
                     }
                   }
                 }
                ).start(); //start the thread (call the run() method in the Runnable object)


      // Wait for the child to finish its work.
      process.waitFor();  // this throws InterruptedException
      outputFile.close();
   }
}

/*
   IMPORTANT:
   This program will not hang if the child process is the program MakeOneLine.java.
*/